require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__SYS_REFCOUNT_H__)) {
    eval 'sub __SYS_REFCOUNT_H__ () {1;}' unless defined(&__SYS_REFCOUNT_H__);
    require 'sys/limits.ph';
    require 'machine/atomic.ph';
    if(defined(&_KERNEL)) {
	require 'sys/systm.ph';
    } else {
	eval 'sub KASSERT {
	    my($exp, $msg) = @_;
    	    eval q();
	}' unless defined(&KASSERT);
    }
    eval 'sub refcount_init {
        my($count,$value) = @_;
	    eval q({ *$count = $value; });
    }' unless defined(&refcount_init);
    eval 'sub refcount_acquire {
        my($count) = @_;
	    eval q({  &KASSERT(*$count <  &UINT_MAX, (\\"refcount %p overflowed\\", $count));  &atomic_add_int($count, 1); });
    }' unless defined(&refcount_acquire);
    eval 'sub refcount_release {
        my($count) = @_;
	    eval q({ \'u_int\'  &old;  &atomic_thread_fence_rel();  &old =  &atomic_fetchadd_int($count, -1);  &KASSERT( &old > 0, (\\"refcount %p is zero\\", $count));  &if ( &old > 1) (0);  &atomic_thread_fence_acq(); (1); });
    }' unless defined(&refcount_release);
    eval 'sub refcount_release_if_not_last {
        my($count) = @_;
	    eval q({ \'u_int\'  &old;  &old = *$count;  &for (;;) {  &KASSERT( &old > 0, (\\"refcount %p is zero\\", $count));  &if ( &old == 1) (0);  &if ( &atomic_fcmpset_int($count,  &old,  &old - 1)) (1); } });
    }' unless defined(&refcount_release_if_not_last);
}
1;
