/* Default linker script, for normal executables */
/* Copyright (C) 2014-2019 Free Software Foundation, Inc.
   Copying and distribution of this script, with or without modification,
   are permitted in any medium without royalty provided the copyright
   notice and this notice are preserved.  */
OUTPUT_FORMAT("elf64-ia64-vms")
ENTRY(__entry)
SECTIONS
{
  /* RW segment.  */
  . = 0x10000;
  $DATA$ ALIGN (0x200) : {
    *($DATA$ .data .data.*)
    *($BSS$ .bss .bss.*)
  }
  /* Code segment.  Note: name must be $CODE$ */
  . = ALIGN (0x10000);
  $CODE$ ALIGN (0x200) : {
    *($CODE$ .text .text.*)
  }
  .plt ALIGN (8) : {
    *(.plt)
  }
  /* RO segment.  */
  . = ALIGN (0x10000);
  /* RO initialized data.  */
  $LITERAL$ ALIGN (0x200) : {
    *($LITERAL$)
    *($READONLY$ .rodata .rodata.*)
    *(.jcr)
    *(.ctors)
    *(.dtors)
    *(.opd)
    *(.gcc_except_table)
    /* LIB stuff.  */
    *(LIB$INITIALIZDZ)	/* Start marker.  */
    *(LIB$INITIALIZD_)	/* Hi priority.  */
    *(LIB$INITIALIZE)	/* User.  */
    *(LIB$INITIALIZE$)	/* End marker.  */
  }
  /* Short segment.  */
  . = ALIGN (0x10000);
  .srodata : {
    *(.srodata .srodata.*)
  }
  .got ALIGN (8) : {
    *(.got)
  }
  .IA_64.pltoff ALIGN (16) : {
    *(.IA_64.pltoff)
  }
  $TFR$ ALIGN (16) : {
    /* Transfer vector.  */
    __entry = .;
    *(.transfer)
  }
  . = ALIGN (0x10000);
  $RW_SHORT$ ALIGN (0x200) : {
    *(.sdata .sdata.*)
    *(.sbss .sbss.*)
  }
  . = ALIGN (0x10000);
  .IA_64.unwind ALIGN (0x200) : {
    *(.IA_64.unwind .IA_64.unwind.*)
  }
  .IA_64.unwind_info ALIGN (8) : {
    *(.IA_64.unwind_info .IA_64.unwind_info.*)
  }
  . = ALIGN (0x10000);
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {
    *(.dynamic)
    *(.vmsdynstr)
    *(.fixups)
  }
  . = ALIGN (0x10000);
  .dynstr : { *(.dynstr) }
  .dynsym         : { *(.dynsym) }
  .rela.got : { *(.rela.got) }
  .got.plt : { *(.got.plt) }
  .gnu.version_d : { *(.gnu.version_d) }
  .gnu.version : { *(.gnu.version) }
  .gnu.version_r : { *(.gnu.version_r) }
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
  /* DWARF 3 */
  .debug_pubtypes 0 : { *(.debug_pubtypes) }
  .debug_ranges   0 : { *(.debug_ranges) }
  /* DWARF Extension.  */
  .debug_macro    0 : { *(.debug_macro) }
  .debug_addr     0 : { *(.debug_addr) }
  .note : { *(.vms.note) }
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }
}
