# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-02-22 12:00
from __future__ import unicode_literals

from django.db import migrations, models

def add_nomad_user(apps, schema_editor):
    try:
        group = apps.get_model("account", "bsdGroups").objects.create(
            bsdgrp_builtin=True,
            bsdgrp_gid="472",
            bsdgrp_group="nomad"
        )
        group.save()
        user = apps.get_model("account", "bsdUsers").objects.create(
            bsdusr_builtin=True,
            bsdusr_full_name="Nomad Daemon",
            bsdusr_group=group,
            bsdusr_home="/var/tmp/nomad",
            bsdusr_shell="/usr/sbin/nologin",
            bsdusr_smbhash="*",
            bsdusr_unixhash="*",
            bsdusr_uid="472",
            bsdusr_username="nomad"
        )
        user.save()

    except Exception as e:
        print("ERROR: unable to create nomad user/group: ", e)

def remove_nomad_user(apps, schema_editor):
    try:
        apps.get_model("account", "bsdUsers").objects.get(
            bsdusr_username="nomad"
        ).delete()
        apps.get_model("account", "bsdGroups").objects.get(
            bsdgrp_group="nomad"
        ).delete()

    except Exception as e:
        print("ERROR: unable to remove nomad user/group: ", e)

class Migration(migrations.Migration):

    dependencies = [
        ('account', '0002_add_consul_user'),
    ]

    operations = [
        migrations.RunPython(
            add_nomad_user,
            reverse_code=remove_nomad_user
        )
    ]
