# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-02-22 12:00
from __future__ import unicode_literals

from django.db import migrations, models

def add_minio_user(apps, schema_editor):
    try:
        group = apps.get_model("account", "bsdGroups").objects.create(
            bsdgrp_builtin=True,
            bsdgrp_gid="473",
            bsdgrp_group="minio"
        )
        group.save()
        user = apps.get_model("account", "bsdUsers").objects.create(
            bsdusr_builtin=True,
            bsdusr_full_name="Minio Daemon",
            bsdusr_group=group,
            bsdusr_home="/var/tmp/minio",
            bsdusr_shell="/usr/sbin/nologin",
            bsdusr_smbhash="*",
            bsdusr_unixhash="*",
            bsdusr_uid="473",
            bsdusr_username="minio"
        )
        user.save()

    except Exception as e:
        print("ERROR: unable to create minio user/group: ", e)

def remove_minio_user(apps, schema_editor):
    try:
        apps.get_model("account", "bsdUsers").objects.get(
            bsdusr_username="minio"
        ).delete()
        apps.get_model("account", "bsdGroups").objects.get(
            bsdgrp_group="minio"
        ).delete()

    except Exception as e:
        print("ERROR: unable to remove minio user/group: ", e)

class Migration(migrations.Migration):

    dependencies = [
        ('account', '0003_add_nomad_user'),
    ]

    operations = [
        migrations.RunPython(
            add_minio_user,
            reverse_code=remove_minio_user
        )
    ]
