# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-02-17 04:26
from __future__ import print_function, unicode_literals

from django.db import migrations

import platform


def is_freebsd(str):
    return str.lower() == "FreeBSD".lower()


def is_standard_x64(str):
    return str.lower() == "standard"


def is_standard_x86(str):
    return str.lower() == "standard-x86"


def is_pluginjail_x86(str):
    return str.lower() == "pluginjail-x86"


def is_pluginjail_x64(str):
    return str.lower() == "pluginjail"


def is_freenas_url(str):
    return str.lower().startswith("http://download.freenas.org")


def freebsd_release():
    return "11"


def jails_url():
    return "http://download.freenas.org/jails"


def plugin_tarball():
    return "freenas-pluginjail-11.0-RELEASE.tgz"


def plugin_mtree():
    return "freenas-pluginjail-11.0-RELEASE.mtree"


def standard_tarball():
    return "freenas-standard-11.0-RELEASE.tgz"


def standard_mtree():
    return "freenas-standard-11.0-RELEASE.mtree"


def pluginjail_x86_url():
    return "%s/%s/x86/%s" % (jails_url(), freebsd_release(), plugin_tarball())


def pluginjail_x86_mtree_url():
    return "%s/%s/x86/%s" % (jails_url(), freebsd_release(), plugin_mtree())


def pluginjail_x64_url():
    return "%s/%s/x64/%s" % (jails_url(), freebsd_release(), plugin_tarball())


def pluginjail_x64_mtree_url():
    return "%s/%s/x64/%s" % (jails_url(), freebsd_release(), plugin_mtree())


def standard_x86_url():
    return "%s/%s/x86/%s" % (jails_url(), freebsd_release(), standard_tarball())


def standard_x86_mtree_url():
    return "%s/%s/x86/%s" % (jails_url(), freebsd_release(), standard_mtree())


def standard_x64_url():
    return "%s/%s/x64/%s" % (jails_url(), freebsd_release(), standard_tarball())


def standard_x64_mtree_url():
    return "%s/%s/x64/%s" % (jails_url(), freebsd_release(), standard_mtree())


def create_standard_x86(apps):
    jt = apps.get_model("jails", "JailTemplate").objects.create()
    jt.jt_name = "standard-x86"
    jt.jt_os = "FreeBSD"
    jt.jt_arch = "x86"
    jt.jt_url = standard_x86_url()
    jt.jt_mtree = standard_x86_mtree_url()
    jt.jt_system = True
    jt.jt_readonly = False
    jt.save()


def create_standard_x64(apps):
    jt = apps.get_model("jails", "JailTemplate").objects.create()
    jt.jt_name = "standard"
    jt.jt_os = "FreeBSD"
    jt.jt_arch = "x64"
    jt.jt_url = standard_x64_url()
    jt.jt_mtree = standard_x64_mtree_url()
    jt.jt_system = True
    jt.jt_readonly = False
    jt.save()


def create_pluginjail_x86(apps):
    jt = apps.get_model("jails", "JailTemplate").objects.create()
    jt.jt_name = "pluginjail-x86"
    jt.jt_os = "FreeBSD"
    jt.jt_arch = "x86"
    jt.jt_url = pluginjail_x86_url()
    jt.jt_mtree = pluginjail_x86_mtree_url()
    jt.jt_system = True
    jt.jt_readonly = False
    jt.save()


def create_pluginjail_x64(apps):
    jt = apps.get_model("jails", "JailTemplate").objects.create()
    jt.jt_name = "pluginjail"
    jt.jt_os = "FreeBSD"
    jt.jt_arch = "x64"
    jt.jt_url = pluginjail_x64_url()
    jt.jt_mtree = pluginjail_x64_mtree_url()
    jt.jt_system = True
    jt.jt_readonly = False
    jt.save()


def update_standard_x86(jt):
    jt.jt_url = standard_x86_url()
    jt.jt_mtree = standard_x86_mtree_url()
    jt.jt_system = True
    jt.save()


def update_standard_x64(jt):
    jt.jt_url = standard_x64_url()
    jt.jt_mtree = standard_x64_mtree_url()
    jt.jt_system = True
    jt.save()


def update_pluginjail_x86(jt):
    jt.jt_url = pluginjail_x86_url()
    jt.jt_mtree = pluginjail_x86_mtree_url()
    jt.jt_system = True
    jt.save()


def update_pluginjail_x64(jt):
    jt.jt_url = pluginjail_x64_url()
    jt.jt_mtree = pluginjail_x64_mtree_url()
    jt.jt_system = True
    jt.save()


def add_jail_templates(apps, schema_editor):
    try:
        release = int(platform.release().split(".")[0])
        if release < int(freebsd_release()):
            print("ERROR: %d is less than %d, refusing migration" % (release, int(freebsd_release())))
            return

    except:
        print("ERROR: unable to determine release version")
        return

    standard_x86_exists = False
    standard_x64_exists = False
    pluginjail_x86_exists = False
    pluginjail_x64_exists = False

    JailTemplate = apps.get_model("jails", "JailTemplate")
    for jt in JailTemplate.objects.all():
        if is_standard_x86(jt.jt_name) and is_freenas_url(jt.jt_url) and is_freebsd(jt.jt_os):
            try:
                update_standard_x86(jt)
                standard_x86_exists = True
            except Exception as e:
                print("ERROR: unable to update x86 standard jail: ", e)

        elif is_standard_x64(jt.jt_name) and is_freenas_url(jt.jt_url) and is_freebsd(jt.jt_os):
            try:
                update_standard_x64(jt)
                standard_x64_exists = True
            except Exception as e:
                print("ERROR: unable to update x64 standard jail: ", e)

        elif is_pluginjail_x86(jt.jt_name) and is_freenas_url(jt.jt_url) and is_freebsd(jt.jt_os):
            try:
                update_pluginjail_x86(jt)
                pluginjail_x86_exists = True
            except Exception as e:
                print("ERROR: unable to update x86 plugin jail: ", e)

        elif is_pluginjail_x64(jt.jt_name) and is_freenas_url(jt.jt_url) and is_freebsd(jt.jt_os):
            try:
                update_pluginjail_x64(jt)
                pluginjail_x64_exists = True
            except Exception as e:
                print("ERROR: unable to update x64 plugin jail: ", e)

    if not standard_x86_exists:
        try:
            create_standard_x86(apps)
        except Exception as e:
            print("ERROR: unable to create x86 standard jail: ", e)
    if not standard_x64_exists:
        try:
            create_standard_x64(apps)
        except Exception as e:
            print("ERROR: unable to create x64 standard jail: ", e)
    if not pluginjail_x86_exists:
        try:
            create_pluginjail_x86(apps)
        except Exception as e:
            print("ERROR: unable to create x86 plugin jail: ", e)
    if not pluginjail_x64_exists:
        try:
            create_pluginjail_x64(apps)
        except Exception as e:
            print("ERROR: unable to create x64 plugin jail: ", e)


def reverse(apps, schema_editor):
    return True


class Migration(migrations.Migration):

    dependencies = [
        ('jails', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(
            add_jail_templates,
            reverse_code=reverse
        ),
    ]
