# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-04-17 23:26
from __future__ import unicode_literals

from django.db import migrations, models


def fix_pluginjail(apps, schema_editor):
    """
    Fix inverted logic introduced in migration 0002
    """
    JailTemplate = apps.get_model('jails', 'JailTemplate')
    for jt in JailTemplate.objects.filter(jt_name='pluginjail'):
        jt.jt_url = jt.jt_url.replace('/x86/', '/x64/')
        jt.jt_mtree = jt.jt_mtree.replace('/x86/', '/x64/')
        jt.save()

    for jt in JailTemplate.objects.filter(jt_name='pluginjail-x86'):
        jt.jt_url = jt.jt_url.replace('/x64/', '/x86/')
        jt.jt_mtree = jt.jt_mtree.replace('/x64/', '/x86/')
        jt.save()


class Migration(migrations.Migration):

    dependencies = [
        ('jails', '0002_templates_to_11'),
    ]

    operations = [
        migrations.RunPython(
            fix_pluginjail,
            reverse_code=lambda x, y: True,
        ),
    ]
