# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:42


import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields
import freenasUI.services.models
from freenasUI.common.system import get_sw_name
from freenasUI import choices


def create_services(apps, schema_editor):
    afp = apps.get_model('services', 'AFP')()
    afp.save()

    cifs = apps.get_model('services', 'CIFS')()
    cifs.cifs_srv_netbiosname = get_sw_name().lower()
    cifs.cifs_srv_workgroup = 'WORKGROUP'
    cifs.cifs_srv_description = '%s Server' % get_sw_name()
    cifs.save()

    ddns = apps.get_model('services', 'DynamicDNS')()
    ddns.save()

    ftp = apps.get_model('services', 'FTP')()
    ftp.save()


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('system', '0001_initial'),
        ('directoryservice', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AFP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('afp_srv_guest', models.BooleanField(default=False, help_text='Allows guest access to all Apple shares on this box.', verbose_name='Guest Access')),
                ('afp_srv_guest_user', freenasUI.freeadmin.models.fields.UserField(default='nobody', help_text="Use this option to override the username ('nobody' by default) which will be used for access to services which are specified as guest. Whatever privileges this user has will be available to any client connecting to the guest service. This user must exist in the password file, but does not require a valid login. The user root cannot be used as guest account.", max_length=120, verbose_name='Guest account')),
                ('afp_srv_bindip', freenasUI.freeadmin.models.fields.MultiSelectField(blank=True, default='', help_text='IP addresses to advertise and listens to. If none specified, advertise the first IP address of the system, but to listen for any incoming request.', max_length=255, verbose_name='Bind IP Addresses')),
                ('afp_srv_connections_limit', models.IntegerField(default=50, help_text='Maximum number of connections permitted via AFP. The default limit is 50.', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(1000)], verbose_name='Max. Connections')),
                ('afp_srv_homedir_enable', models.BooleanField(default=False, help_text='Enable/disable home directories for AFP user.', verbose_name='Enable home directories')),
                ('afp_srv_homedir', freenasUI.freeadmin.models.fields.PathField(blank=True, max_length=255, null=True, verbose_name='Home directories')),
                ('afp_srv_homename', models.CharField(blank=True, help_text='When set, overrides the default Home Share Name.', max_length=50, verbose_name='Home share name')),
                ('afp_srv_dbpath', freenasUI.freeadmin.models.fields.PathField(blank=True, help_text='Sets the database information to be stored in path. You have to specify a writable location, even if the volume is read only.', max_length=255, null=True, verbose_name='Database Path')),
                ('afp_srv_global_aux', models.TextField(blank=True, help_text='These parameters are added to the [Global] section of afp.conf', verbose_name='Global auxiliary parameters')),
                ('afp_srv_map_acls', models.CharField(choices=choices.AFP_MAP_ACLS_CHOICES, default='rights', help_text='How to map the effective permissions of authenticated users: Rights (default, Unix-style permissions), Mode (ACLs), or None', max_length=120, verbose_name='Map ACLs')),
            ],
            options={
                'verbose_name': 'AFP',
                'verbose_name_plural': 'AFP',
            },
        ),
        migrations.CreateModel(
            name='CIFS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cifs_srv_netbiosname', models.CharField(max_length=120, verbose_name='NetBIOS name')),
                ('cifs_srv_netbiosname_b', models.CharField(blank=True, max_length=120, null=True, verbose_name='NetBIOS name')),
                ('cifs_srv_netbiosalias', models.CharField(blank=True, max_length=120, null=True, verbose_name='NetBIOS alias')),
                ('cifs_srv_workgroup', models.CharField(help_text='Workgroup the server will appear to be in when queried by clients (maximum 15 characters).', max_length=120, verbose_name='Workgroup')),
                ('cifs_srv_description', models.CharField(blank=True, help_text='Server description. This can usually be left blank.', max_length=120, verbose_name='Description')),
                ('cifs_srv_doscharset', models.CharField(default='CP437', max_length=120, verbose_name='DOS charset')),
                ('cifs_srv_unixcharset', models.CharField(choices=choices.UNIXCHARSET_CHOICES, default='UTF-8', max_length=120, verbose_name='UNIX charset')),
                ('cifs_srv_loglevel', models.CharField(choices=choices.LOGLEVEL_CHOICES, default='0', max_length=120, verbose_name='Log level')),
                ('cifs_srv_syslog', models.BooleanField(default=False, verbose_name='Use syslog only')),
                ('cifs_srv_localmaster', models.BooleanField(default=False, verbose_name='Local Master')),
                ('cifs_srv_domain_logons', models.BooleanField(default=False, verbose_name='Domain logons')),
                ('cifs_srv_timeserver', models.BooleanField(default=False, verbose_name='Time Server for Domain')),
                ('cifs_srv_guest', freenasUI.freeadmin.models.fields.UserField(default='nobody', help_text="Use this option to override the username ('nobody' by default) which will be used for access to services which are specified as guest. Whatever privileges this user has will be available to any client connecting to the guest service. This user must exist in the password file, but does not require a valid login. The user root cannot be used as guest account.", max_length=120, verbose_name='Guest account')),
                ('cifs_srv_filemask', models.CharField(blank=True, help_text='Use this option to override the file creation mask (0666 by default).', max_length=120, verbose_name='File mask')),
                ('cifs_srv_dirmask', models.CharField(blank=True, help_text='Use this option to override the directory creation mask (0777 by default).', max_length=120, verbose_name='Directory mask')),
                ('cifs_srv_nullpw', models.BooleanField(default=False, verbose_name='Allow Empty Password')),
                ('cifs_srv_smb_options', models.TextField(blank=True, help_text='These parameters are added to the [global] section of smb.conf', verbose_name='Auxiliary parameters')),
                ('cifs_srv_unixext', models.BooleanField(default=True, help_text='These extensions enable Samba to better serve UNIX SMB clients by supporting features such as symbolic links, hard links, etc...', verbose_name='Unix Extensions')),
                ('cifs_srv_aio_enable', models.BooleanField(default=False, editable=False, help_text='Enable/disable AIO support.', verbose_name='Enable AIO')),
                ('cifs_srv_aio_rs', models.IntegerField(default=4096, editable=False, help_text='Samba will read asynchronously if request size is larger than this value.', verbose_name='Minimum AIO read size')),
                ('cifs_srv_aio_ws', models.IntegerField(default=4096, editable=False, help_text='Samba will write asynchronously if request size is larger than this value.', verbose_name='Minimum AIO write size')),
                ('cifs_srv_zeroconf', models.BooleanField(default=True, help_text='Zeroconf support via Avahi allows clients (the Mac OSX finder in particular) to automatically discover the SMB shares on the system similar to the Computer Browser service in Windows.', verbose_name='Zeroconf share discovery')),
                ('cifs_srv_hostlookup', models.BooleanField(default=True, help_text='Specifies whether Samba should use (expensive) hostname lookups or use IP addresses instead. An example place where hostname lookups are currently used is when checking the hosts deny and hosts allow.', verbose_name='Hostnames lookups')),
                ('cifs_srv_min_protocol', models.CharField(blank=True, choices=choices.CIFS_SMB_PROTO_CHOICES, help_text='The minimum protocol version that will be supported by the server', max_length=120, verbose_name='Server minimum protocol')),
                ('cifs_srv_max_protocol', models.CharField(choices=choices.CIFS_SMB_PROTO_CHOICES, default='SMB3', help_text='The highest protocol version that will be supported by the server', max_length=120, verbose_name='Server maximum protocol')),
                ('cifs_srv_allow_execute_always', models.BooleanField(default=True, help_text='This boolean parameter controls the behaviour of smbd(8) when receiving a protocol request of "open for execution" from a Windows client. With Samba 3.6 and older, the execution right in the ACL was not checked, so a client could execute a file even if it did not have execute rights on the file. In Samba 4.0, this has been fixed, so that by default, i.e. when this parameter is set to "False", "open for execution" is now denied when execution permissions are not present. If this parameter is set to "True", Samba does not check execute permissions on "open for execution", thus re-establishing the behavior of Samba 3.6 ', verbose_name='Allow execute always')),
                ('cifs_srv_obey_pam_restrictions', models.BooleanField(default=True, help_text="This parameter controls whether or not Samba should obey PAM's account and session management directives", verbose_name='Obey pam restrictions')),
                ('cifs_srv_bindip', freenasUI.freeadmin.models.fields.MultiSelectField(blank=True, help_text='IP addresses to bind to. If none specified, all available interfaces that are up will be listened on.', max_length=250, null=True, verbose_name='Bind IP Addresses')),
                ('cifs_SID', models.CharField(blank=True, max_length=120, null=True)),
            ],
            options={
                'verbose_name': 'SMB',
                'verbose_name_plural': 'SMB',
            },
        ),
        migrations.CreateModel(
            name='DomainController',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dc_realm', models.CharField(help_text='Realm Name, eg EXAMPLE.ORG', max_length=120, verbose_name='Realm')),
                ('dc_domain', models.CharField(help_text='Domain Name in old format, eg EXAMPLE', max_length=120, verbose_name='Domain')),
                ('dc_role', models.CharField(choices=choices.SAMBA4_ROLE_CHOICES, default='dc', help_text='Server Role', max_length=120, verbose_name='Server Role')),
                ('dc_dns_backend', models.CharField(choices=choices.SAMBA4_DNS_BACKEND_CHOICES, default='SAMBA_INTERNAL', help_text='DNS Backend, eg SAMBA_INTERNAL', max_length=120, verbose_name='DNS Backend')),
                ('dc_dns_forwarder', models.CharField(help_text='DNS Forwarder IP Address', max_length=120, verbose_name='DNS Forwarder')),
                ('dc_forest_level', models.CharField(choices=choices.SAMBA4_FOREST_LEVEL_CHOICES, default='2003', help_text='Domain and Forest Level, eg 2003', max_length=120, verbose_name='Domain Forest Level')),
                ('dc_passwd', models.CharField(help_text='Administrator Password', max_length=120, verbose_name='Administrator Password')),
                ('dc_kerberos_realm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosRealm', verbose_name='Kerberos Realm')),
            ],
            options={
                'verbose_name': 'Domain Controller',
                'verbose_name_plural': 'Domain Controller',
            },
        ),
        migrations.CreateModel(
            name='DynamicDNS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ddns_provider', models.CharField(blank=True, default='dyndns@3322.org', choices=choices.DYNDNSPROVIDER_CHOICES(), max_length=120, verbose_name='Provider')),
                ('ddns_ipserver', models.CharField(blank=True, default='checkip.dyndns.org:80 /.', help_text="The client IP is detected by calling 'url' from this 'ip_server_name:port /.'. Leaving this field blank causes the service to use its built in default: checkip.dyndns.org:80 /.", max_length=150, verbose_name='IP Server')),
                ('ddns_domain', models.CharField(blank=True, help_text='A host name alias. This option can appear multiple times, for each domain that has the same IP. Use a comma to separate multiple alias names.  Some Dynamic DNS providers require a hash after the host name, for these providers use a # sign in the between the hostname and hash in the format hostname#hash.  You may also use multiple hostname and hash combinations in the format host1#hash1,host2#hash2.', max_length=120, verbose_name='Domain name')),
                ('ddns_username', models.CharField(max_length=120, verbose_name='Username')),
                ('ddns_password', models.CharField(max_length=120, verbose_name='Password')),
                ('ddns_updateperiod', models.CharField(blank=True, help_text='Time in seconds. Default is about 1 min.', max_length=120, verbose_name='Update period')),
                ('ddns_fupdateperiod', models.CharField(blank=True, max_length=120, verbose_name='Forced update period')),
                ('ddns_options', models.TextField(blank=True, help_text='These parameters will be added to global settings in inadyn-mt.conf.', verbose_name='Auxiliary parameters')),
            ],
            options={
                'verbose_name': 'Dynamic DNS',
                'verbose_name_plural': 'Dynamic DNS',
            },
        ),
        migrations.CreateModel(
            name='FibreChannelToTarget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fc_port', models.CharField(max_length=10, verbose_name='Port')),
            ],
            options={
                'verbose_name': 'Fibre Channel Target',
                'verbose_name_plural': 'Fibre Channel Targets',
            },
        ),
        migrations.CreateModel(
            name='FTP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ftp_port', models.PositiveIntegerField(default=21, help_text='Port to bind FTP server.', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Port')),
                ('ftp_clients', models.PositiveIntegerField(default=32, help_text='Maximum number of simultaneous clients.', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(10000)], verbose_name='Clients')),
                ('ftp_ipconnections', models.PositiveIntegerField(default=0, help_text='Maximum number of connections per IP address (0 = unlimited).', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1000)], verbose_name='Connections')),
                ('ftp_loginattempt', models.PositiveIntegerField(default=3, help_text='Maximum number of allowed password attempts before disconnection.', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1000)], verbose_name='Login Attempts')),
                ('ftp_timeout', models.PositiveIntegerField(default=120, help_text='Maximum idle time in seconds.', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(10000)], verbose_name='Timeout')),
                ('ftp_rootlogin', models.BooleanField(default=False, verbose_name='Allow Root Login')),
                ('ftp_onlyanonymous', models.BooleanField(default=False, verbose_name='Allow Anonymous Login')),
                ('ftp_anonpath', freenasUI.freeadmin.models.fields.PathField(blank=True, max_length=255, null=True, verbose_name='Path')),
                ('ftp_onlylocal', models.BooleanField(default=False, verbose_name='Allow Local User Login')),
                ('ftp_banner', models.TextField(blank=True, help_text='Message which will be displayed to the user when they initially login.', max_length=120, verbose_name='Display Login')),
                ('ftp_filemask', models.CharField(default='077', help_text='Override the file creation mask (077 by default).', max_length=3, verbose_name='File mask')),
                ('ftp_dirmask', models.CharField(default='077', help_text='Override the directory creation mask (077 by default).', max_length=3, verbose_name='Directory mask')),
                ('ftp_fxp', models.BooleanField(default=False, verbose_name='Enable FXP')),
                ('ftp_resume', models.BooleanField(default=False, verbose_name='Allow Transfer Resumption')),
                ('ftp_defaultroot', models.BooleanField(default=False, help_text='For local users, only allow access to user home directory unless the user is a member of group wheel.', verbose_name='Always Chroot')),
                ('ftp_ident', models.BooleanField(default=False, verbose_name='Require IDENT Authentication')),
                ('ftp_reversedns', models.BooleanField(default=False, verbose_name='Perform Reverse DNS Lookups')),
                ('ftp_masqaddress', models.CharField(blank=True, help_text='Cause the server to display the network information for the specified address to the client, on the assumption that IP address or DNS host is acting as a NAT gateway or port forwarder for the server.', max_length=120, verbose_name='Masquerade address')),
                ('ftp_passiveportsmin', models.PositiveIntegerField(default=0, help_text='The minimum port to allocate for PASV style data connections (0 = use any port).', verbose_name='Minimum passive port')),
                ('ftp_passiveportsmax', models.PositiveIntegerField(default=0, help_text='The maximum port to allocate for PASV style data connections (0 = use any port). Passive ports restricts the range of ports from which the server will select when sent the PASV command from a client. The server will randomly choose a number from within the specified range until an open port is found. The port range selected must be in the non-privileged range (eg. greater than or equal to 1024). It is strongly recommended that the chosen range be large enough to handle many simultaneous passive connections (for example, 49152-65534, the IANA-registered ephemeral port range).', verbose_name='Maximum passive port')),
                ('ftp_localuserbw', models.PositiveIntegerField(default=0, help_text='Local user upload bandwidth in KB/s. Zero means infinity.', verbose_name='Local user upload bandwidth')),
                ('ftp_localuserdlbw', models.PositiveIntegerField(default=0, help_text='Local user download bandwidth in KB/s. Zero means infinity.', verbose_name='Local user download bandwidth')),
                ('ftp_anonuserbw', models.PositiveIntegerField(default=0, help_text='Anonymous user upload bandwidth in KB/s. Zero means infinity.', verbose_name='Anonymous user upload bandwidth')),
                ('ftp_anonuserdlbw', models.PositiveIntegerField(default=0, help_text='Anonymous user download bandwidth in KB/s. Zero means infinity.', verbose_name='Anonymous user download bandwidth')),
                ('ftp_tls', models.BooleanField(default=False, verbose_name='Enable TLS')),
                ('ftp_tls_policy', models.CharField(choices=choices.FTP_TLS_POLICY_CHOICES, default='on', max_length=120, verbose_name='TLS policy')),
                ('ftp_tls_opt_allow_client_renegotiations', models.BooleanField(default=False, verbose_name='TLS allow client renegotiations')),
                ('ftp_tls_opt_allow_dot_login', models.BooleanField(default=False, verbose_name='TLS allow dot login')),
                ('ftp_tls_opt_allow_per_user', models.BooleanField(default=False, verbose_name='TLS allow per user')),
                ('ftp_tls_opt_common_name_required', models.BooleanField(default=False, verbose_name='TLS common name required')),
                ('ftp_tls_opt_enable_diags', models.BooleanField(default=False, verbose_name='TLS enable diagnostics')),
                ('ftp_tls_opt_export_cert_data', models.BooleanField(default=False, verbose_name='TLS export certificate data')),
                ('ftp_tls_opt_no_cert_request', models.BooleanField(default=False, verbose_name='TLS no certificate request')),
                ('ftp_tls_opt_no_empty_fragments', models.BooleanField(default=False, verbose_name='TLS no empty fragments')),
                ('ftp_tls_opt_no_session_reuse_required', models.BooleanField(default=False, verbose_name='TLS no session reuse required')),
                ('ftp_tls_opt_stdenvvars', models.BooleanField(default=False, verbose_name='TLS export standard vars')),
                ('ftp_tls_opt_dns_name_required', models.BooleanField(default=False, verbose_name='TLS DNS name required')),
                ('ftp_tls_opt_ip_address_required', models.BooleanField(default=False, verbose_name='TLS IP address required')),
                ('ftp_options', models.TextField(blank=True, help_text='These parameters are added to proftpd.conf.', max_length=120, verbose_name='Auxiliary parameters')),
                ('ftp_ssltls_certificate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.Certificate', verbose_name='Certificate')),
            ],
            options={
                'verbose_name': 'FTP',
                'verbose_name_plural': 'FTP',
            },
        ),
        migrations.CreateModel(
            name='iSCSITarget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_name', models.CharField(help_text="Base Name will be appended automatically when starting without 'iqn.', 'eui.' or 'naa.'.", max_length=120, unique=True, verbose_name='Target Name')),
                ('iscsi_target_alias', models.CharField(blank=True, help_text='Optional user-friendly string of the target.', max_length=120, null=True, unique=True, verbose_name='Target Alias')),
                ('iscsi_target_mode', models.CharField(choices=[('iscsi', 'iSCSI'), ('fc', 'Fibre Channel'), ('both', 'Both')], default='iscsi', max_length=20, verbose_name='Target Mode')),
            ],
            options={
                'ordering': ['iscsi_target_name'],
                'verbose_name': 'Target',
                'verbose_name_plural': 'Targets',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetAuthCredential',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_auth_tag', models.IntegerField(default=1, verbose_name='Group ID')),
                ('iscsi_target_auth_user', models.CharField(help_text='Target side user name. It is usually the initiator name by default.', max_length=120, verbose_name='User')),
                ('iscsi_target_auth_secret', models.CharField(help_text='Target side secret.', max_length=120, verbose_name='Secret')),
                ('iscsi_target_auth_peeruser', models.CharField(blank=True, help_text='Initiator side user name.', max_length=120, verbose_name='Peer User')),
                ('iscsi_target_auth_peersecret', models.CharField(blank=True, help_text='Initiator side secret. (for mutual CHAP authentication)', max_length=120, verbose_name='Peer Secret')),
            ],
            options={
                'verbose_name': 'Authorized Access',
                'verbose_name_plural': 'Authorized Accesses',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetAuthorizedInitiator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_initiator_tag', models.IntegerField(default=1, unique=True, verbose_name='Group ID')),
                ('iscsi_target_initiator_initiators', models.TextField(default='ALL', help_text="Initiator authorized to access to the iSCSI target. It takes a name or 'ALL' for any initiators.", max_length=2048, verbose_name='Initiators')),
                ('iscsi_target_initiator_auth_network', models.TextField(default='ALL', help_text="Network authorized to access to the iSCSI target. It takes IP or CIDR addresses or 'ALL' for any IPs.", max_length=2048, verbose_name='Authorized network')),
                ('iscsi_target_initiator_comment', models.CharField(blank=True, help_text='You may enter a description here for your reference.', max_length=120, verbose_name='Comment')),
            ],
            options={
                'verbose_name': 'Initiator',
                'verbose_name_plural': 'Initiators',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetExtent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_extent_name', models.CharField(help_text='String identifier of the extent.', max_length=120, unique=True, verbose_name='Extent Name')),
                ('iscsi_target_extent_serial', models.CharField(default=freenasUI.services.models.extent_serial, help_text='Serial number for the logical unit', max_length=16, verbose_name='Serial')),
                ('iscsi_target_extent_type', models.CharField(help_text='Type used as extent.', max_length=120, verbose_name='Extent Type')),
                ('iscsi_target_extent_path', models.CharField(help_text='File path (e.g. /mnt/sharename/extent/extent0) used as extent.', max_length=120, verbose_name='Path to the extent')),
                ('iscsi_target_extent_filesize', models.CharField(default=0, help_text='Size of extent: 0 means auto, a raw number is bytes, or suffix with KB, MB, or TB for convenience.', max_length=120, verbose_name='Extent size')),
                ('iscsi_target_extent_blocksize', models.IntegerField(choices=choices.TARGET_BLOCKSIZE_CHOICES, default=512, help_text='Logical block length (512 by default). The recommended length for compatibility is 512.', verbose_name='Logical Block Size')),
                ('iscsi_target_extent_pblocksize', models.BooleanField(default=False, help_text='By default, the physical blocksize is reported as the ZFS block size, which can be up to 128K. Some initiators do not work with values above 4K. Checking this disables reporting the physical blocksize.', verbose_name='Disable Physical Block Size Reporting')),
                ('iscsi_target_extent_avail_threshold', models.IntegerField(blank=True, help_text='Remaining dataset/zvol capacity warning threshold', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(99)], verbose_name='Available Space Threshold (%)')),
                ('iscsi_target_extent_comment', models.CharField(blank=True, help_text='A description can be entered here for your reference.', max_length=120, verbose_name='Comment')),
                ('iscsi_target_extent_naa', models.CharField(blank=True, editable=False, max_length=34, unique=True, verbose_name='NAA...used only by the initiator')),
                ('iscsi_target_extent_insecure_tpc', models.BooleanField(default=True, help_text='Allow initiators to xcopy without authenticating to foreign targets.', verbose_name='Enable TPC')),
                ('iscsi_target_extent_xen', models.BooleanField(default=False, help_text='Xen inititors give errors when connecting to LUNs using the FreeNAS default naming scheme.  Checking this alters the naming scheme to be more Xen-friendly', verbose_name='Xen initiator compat mode')),
                ('iscsi_target_extent_rpm', models.CharField(choices=choices.EXTENT_RPM_CHOICES, default='SSD', help_text='RPM reported to initiators for this extent/LUN. The default is SSD because Windows will attempt to defrag non SSD devices.  This is a pathological worst-case situation for ZFS.  VMWare gives the option to use SSD LUNs as swap devices. There is some value to picking a non-SSD RPM if your extent is indeed not SSDs and the initiator will be VMWare.', max_length=20, verbose_name='LUN RPM')),
                ('iscsi_target_extent_ro', models.BooleanField(default=False, verbose_name='Read-only')),
                ('iscsi_target_extent_legacy', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['iscsi_target_extent_name'],
                'verbose_name': 'Extent',
                'verbose_name_plural': 'Extents',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetGlobalConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_basename', models.CharField(help_text="The base name (e.g. iqn.2005-10.org.freenas.ctl, see RFC 3720 and 3721 for details) will append the target name that is not starting with 'iqn.', 'eui.' or 'naa.'", max_length=120, verbose_name='Base Name')),
                ('iscsi_isns_servers', models.TextField(blank=True, help_text='List of Internet Storage Name Service (iSNS) Servers', verbose_name='iSNS Servers')),
                ('iscsi_pool_avail_threshold', models.IntegerField(blank=True, help_text='Remaining ZFS pool capacity warning threshold when using zvol extents', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(99)], verbose_name='Pool Available Space Threshold (%)')),
                ('iscsi_alua', models.BooleanField(default=False, help_text='Enabling this feature requires initiator reconfiguration', verbose_name='Enable iSCSI ALUA')),
            ],
            options={
                'verbose_name': 'Target Global Configuration',
                'verbose_name_plural': 'Target Global Configuration',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetGroups',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_authtype', models.CharField(choices=choices.AUTHMETHOD_CHOICES, default='None', help_text='The authentication method accepted by the target.', max_length=120, verbose_name='Auth Method')),
                ('iscsi_target_authgroup', models.IntegerField(blank=True, null=True, verbose_name='Authentication Group ID')),
                ('iscsi_target_initialdigest', models.CharField(default='Auto', help_text='The method can be accepted by the target. Auto means both none and authentication.', max_length=120, verbose_name='Auth Method')),
                ('iscsi_target', models.ForeignKey(help_text='Target this group belongs to', on_delete=django.db.models.deletion.CASCADE, to='services.iSCSITarget', verbose_name='Target')),
                ('iscsi_target_initiatorgroup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='services.iSCSITargetAuthorizedInitiator', verbose_name='Initiator Group ID')),
            ],
            options={
                'verbose_name': 'iSCSI Group',
                'verbose_name_plural': 'iSCSI Groups',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetPortal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_portal_tag', models.IntegerField(default=1, verbose_name='Portal Group ID')),
                ('iscsi_target_portal_comment', models.CharField(blank=True, help_text='A description can be entered here for your reference.', max_length=120, verbose_name='Comment')),
                ('iscsi_target_portal_discoveryauthmethod', models.CharField(choices=choices.AUTHMETHOD_CHOICES, default='None', max_length=120, verbose_name='Discovery Auth Method')),
                ('iscsi_target_portal_discoveryauthgroup', models.IntegerField(blank=True, null=True, verbose_name='Discovery Auth Group')),
            ],
            options={
                'verbose_name': 'Portal',
                'verbose_name_plural': 'Portals',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetPortalIP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_target_portalip_ip', models.GenericIPAddressField(verbose_name='IP Address')),
                ('iscsi_target_portalip_port', models.SmallIntegerField(default=3260, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Port')),
                ('iscsi_target_portalip_portal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ips', to='services.iSCSITargetPortal', verbose_name='Portal')),
            ],
            options={
                'verbose_name': 'Portal IP',
                'verbose_name_plural': 'Portal IPs',
            },
        ),
        migrations.CreateModel(
            name='iSCSITargetToExtent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iscsi_lunid', models.IntegerField(null=True, verbose_name='LUN ID')),
                ('iscsi_extent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='services.iSCSITargetExtent', verbose_name='Extent')),
                ('iscsi_target', models.ForeignKey(help_text='Target this extent belongs to', on_delete=django.db.models.deletion.CASCADE, to='services.iSCSITarget', verbose_name='Target')),
            ],
            options={
                'ordering': ['iscsi_target', 'iscsi_lunid'],
                'verbose_name': 'Target / Extent',
                'verbose_name_plural': 'Targets / Extents',
            },
        ),
        migrations.CreateModel(
            name='LLDP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lldp_intdesc', models.BooleanField(default=True, help_text='Save received info in interface description / alias', verbose_name='Interface Description')),
                ('lldp_country', models.CharField(blank=True, help_text='Specify a two-letterISO 3166 country code (required for LLDPlocation support)', max_length=2, verbose_name='Country Code')),
                ('lldp_location', models.CharField(blank=True, help_text='Specify the physical location of the host', max_length=200, verbose_name='Location')),
            ],
            options={
                'verbose_name': 'LLDP',
                'verbose_name_plural': 'LLDP',
            },
        ),
        migrations.CreateModel(
            name='NFS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nfs_srv_servers', models.PositiveIntegerField(default=4, help_text='Specifies how many servers to create. There should be enough to handle the maximum level of concurrency from clients, typically four to six.', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(256)], verbose_name='Number of servers')),
                ('nfs_srv_udp', models.BooleanField(default=False, verbose_name='Serve UDP NFS clients')),
                ('nfs_srv_allow_nonroot', models.BooleanField(default=False, help_text='Allow non-root mount requests to be served. This should only be specified if there are clients that require it. It will automatically clear the vfs.nfsrv.nfs_privport sysctl flag, which controls if the kernel will accept NFS requests from reserved ports only.', verbose_name='Allow non-root mount')),
                ('nfs_srv_v4', models.BooleanField(default=False, verbose_name='Enable NFSv4')),
                ('nfs_srv_v4_v3owner', models.BooleanField(default=False, help_text='Use the NFSv3 ownership model for NFSv4.  This circumvents the need to sync users and groups between the client and server. Note that this option is mutually incompatible with the > 16 groups option.', verbose_name='NFSv3 ownership model for NFSv4')),
                ('nfs_srv_v4_krb', models.BooleanField(default=False, verbose_name='Require Kerberos for NFSv4')),
                ('nfs_srv_bindip', models.CharField(blank=True, help_text='Select the IP addresses to listen to for NFS requests. If left unchecked, NFS will listen on all available addresses.', max_length=250, verbose_name='Bind IP Addresses')),
                ('nfs_srv_mountd_port', models.SmallIntegerField(blank=True, help_text='Force mountd to bind to the specified port, for both IPv4 and IPv6 address families. This is typically done to ensure that the port which mountd binds to is a known value which can be used in firewall rulesets.', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='mountd(8) bind port')),
                ('nfs_srv_rpcstatd_port', models.SmallIntegerField(blank=True, help_text='Forces the rpc.statd daemon to bind to the specified port, for both IPv4 and IPv6 address families.', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='rpc.statd(8) bind port')),
                ('nfs_srv_rpclockd_port', models.SmallIntegerField(blank=True, help_text='Force the rpc.lockd daemon to bind to the specified port, for both IPv4 and IPv6 address families.', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='rpc.lockd(8) bind port')),
                ('nfs_srv_16', models.BooleanField(default=False, help_text='Ignore the group membership sent on the wire by the NFS client and look up the group membership on the server.  Note that this option is mutually incompatible with the NFSv3 ownership model for NFSv4.', verbose_name='Support >16 groups')),
                ('nfs_srv_mountd_log', models.BooleanField(default=True, help_text='Enable/disable mountd logging into syslog.', verbose_name='Log mountd(8) requests')),
                ('nfs_srv_statd_lockd_log', models.BooleanField(default=False, help_text='Enable/disable statd and lockd logging into syslog.', verbose_name='Log rpc.statd(8) and rpc.lockd(8)')),
            ],
            options={
                'verbose_name': 'NFS',
                'verbose_name_plural': 'NFS',
            },
        ),
        migrations.CreateModel(
            name='RPCToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=1024)),
                ('secret', models.CharField(max_length=1024)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Rsyncd',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rsyncd_port', models.IntegerField(default=873, help_text='Alternate TCP port. Default is 873', verbose_name='TCP Port')),
                ('rsyncd_auxiliary', models.TextField(blank=True, help_text='These parameters will be added to [global] settings in rsyncd.conf', verbose_name='Auxiliary parameters')),
            ],
            options={
                'verbose_name': 'Configure Rsyncd',
                'verbose_name_plural': 'Configure Rsyncd',
            },
        ),
        migrations.CreateModel(
            name='RsyncMod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rsyncmod_name', models.CharField(max_length=120, verbose_name='Module name')),
                ('rsyncmod_comment', models.CharField(blank=True, max_length=120, verbose_name='Comment')),
                ('rsyncmod_path', freenasUI.freeadmin.models.fields.PathField(help_text='Path to be shared', max_length=255, verbose_name='Path')),
                ('rsyncmod_mode', models.CharField(choices=choices.ACCESS_MODE, default='rw', help_text='Control the access a remote host has to this module', max_length=120, verbose_name='Access Mode')),
                ('rsyncmod_maxconn', models.IntegerField(default=0, help_text='Maximum number of simultaneous connections. Default is 0 (unlimited).', verbose_name='Maximum connections')),
                ('rsyncmod_user', freenasUI.freeadmin.models.fields.UserField(default='nobody', help_text="Specify the user name for file transfers to and from that module. In combination with the 'Group' option, this determines which file permissions are available. Leave this field empty to use default settings.", max_length=120, verbose_name='User')),
                ('rsyncmod_group', freenasUI.freeadmin.models.fields.GroupField(default='nobody', help_text='Specify the group name for file transfers to and from that module. Leave this field empty to use default settings.', max_length=120, verbose_name='Group')),
                ('rsyncmod_hostsallow', models.TextField(blank=True, help_text='This option is a comma, space, or tab delimited set of hosts which are permitted to access this module. You can specify the hosts by name or IP number. Leave this field empty to use default settings.', verbose_name='Hosts allow')),
                ('rsyncmod_hostsdeny', models.TextField(blank=True, help_text='A comma, space, or tab-delimited set of hosts which are NOT permitted to access this module. Where the lists conflict, the allow list takes precedence. In the event that it is necessary to deny all by default, use the keyword ALL (or the netmask 0.0.0.0/0) and then explicitly specify in the hosts allow parameter those hosts that should be permitted access. Leave this field empty to use default settings.', verbose_name='Hosts deny')),
                ('rsyncmod_auxiliary', models.TextField(blank=True, help_text='These parameters will be added to the module configuration in rsyncd.conf.', verbose_name='Auxiliary parameters')),
            ],
            options={
                'ordering': ['rsyncmod_name'],
                'verbose_name': 'Rsync Module',
                'verbose_name_plural': 'Rsync Modules',
            },
        ),
        migrations.CreateModel(
            name='services',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('srv_service', models.CharField(help_text='Name of Service, should be auto-generated at build time', max_length=120, verbose_name='Service')),
                ('srv_enable', models.BooleanField(default=False, verbose_name='Enable Service')),
            ],
            options={
                'verbose_name': 'Services',
                'verbose_name_plural': 'Services',
            },
        ),
        migrations.CreateModel(
            name='SMART',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('smart_interval', models.IntegerField(default=30, help_text='Set the interval between disk checks to N minutes. The default is 30 minutes.', verbose_name='Check interval')),
                ('smart_powermode', models.CharField(choices=choices.SMART_POWERMODE, default='never', max_length=60, verbose_name='Power mode')),
                ('smart_difference', models.IntegerField(default=0, help_text='Report if the temperature has changed by at least N degrees Celsius since the last report. 0 to disable.', verbose_name='Difference')),
                ('smart_informational', models.IntegerField(default=0, help_text='Report as informational in the system log if the temperature is greater or equal than N degrees Celsius. 0 to disable.', verbose_name='Informational')),
                ('smart_critical', models.IntegerField(default=0, help_text='Report as critical in the system log and send an email if the temperature is greater or equal than N degrees Celsius. 0 to disable.', verbose_name='Critical')),
                ('smart_email', models.CharField(blank=True, help_text='Destination email address. Separate email addresses with commas.', max_length=255, verbose_name='Email to report')),
            ],
            options={
                'verbose_name': 'S.M.A.R.T.',
                'verbose_name_plural': 'S.M.A.R.T.',
            },
        ),
        migrations.CreateModel(
            name='SNMP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('snmp_location', models.CharField(blank=True, help_text="Location information, e.g. physical location of this system: 'Floor of building, Room xyzzy'.", max_length=255, verbose_name='Location')),
                ('snmp_contact', models.CharField(blank=True, help_text="Contact information, e.g. name or email of the person responsible for this system: 'admin@email.address'.", max_length=120, verbose_name='Contact')),
                ('snmp_traps', models.BooleanField(default=False, editable=False, verbose_name='Send SNMP Traps')),
                ('snmp_v3', models.BooleanField(default=False, verbose_name='SNMP v3 Support')),
                ('snmp_community', models.CharField(blank=True, default='public', help_text="In most cases, 'public' is used here.", max_length=120, verbose_name='Community')),
                ('snmp_v3_username', models.CharField(blank=True, max_length=20, verbose_name='Username')),
                ('snmp_v3_authtype', models.CharField(blank=True, choices=[('MD5', 'MD5'), ('SHA', 'SHA')], default='SHA', max_length=3, verbose_name='Authentication Type')),
                ('snmp_v3_password', models.CharField(blank=True, max_length=50, verbose_name='Password')),
                ('snmp_v3_privproto', models.CharField(blank=True, choices=[('AES', 'AES'), ('DES', 'DES')], max_length=3, null=True, verbose_name='Privacy Protocol')),
                ('snmp_v3_privpassphrase', models.CharField(blank=True, max_length=100, null=True, verbose_name='Privacy Passphrase')),
                ('snmp_options', models.TextField(blank=True, help_text='These parameters will be added to /etc/snmpd.config.', verbose_name='Auxiliary parameters')),
            ],
            options={
                'verbose_name': 'SNMP',
                'verbose_name_plural': 'SNMP',
            },
        ),
        migrations.CreateModel(
            name='SSH',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ssh_bindiface', freenasUI.freeadmin.models.fields.MultiSelectField(blank=True, choices=list(choices.NICChoices(exclude_configured=False)), default='', help_text='Interfaces to advertise and listens to. If none specified, listen for in all available addresses.', max_length=350, verbose_name='Bind Interfaces')),
                ('ssh_tcpport', models.PositiveIntegerField(default=22, help_text='Alternate TCP port. Default is 22', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='TCP Port')),
                ('ssh_rootlogin', models.BooleanField(default=False, help_text='Disabled: Root can only login via public key authentication; Enabled: Root login permitted with password', verbose_name='Login as Root with password')),
                ('ssh_passwordauth', models.BooleanField(default=False, verbose_name='Allow Password Authentication')),
                ('ssh_kerberosauth', models.BooleanField(default=False, verbose_name='Allow Kerberos Authentication')),
                ('ssh_tcpfwd', models.BooleanField(default=False, verbose_name='Allow TCP Port Forwarding')),
                ('ssh_compression', models.BooleanField(default=False, verbose_name='Compress Connections')),
                ('ssh_privatekey', models.TextField(blank=True, editable=False, help_text='Paste a RSA PRIVATE KEY in PEM format here.', max_length=1024, verbose_name='Host Private Key')),
                ('ssh_sftp_log_level', models.CharField(blank=True, choices=choices.SFTP_LOG_LEVEL, help_text='Specifies which messages will be logged by sftp-server. INFO and VERBOSE log transactions that sftp-server performs on behalf of the client. DEBUG2 and DEBUG3 each specify higher levels of debugging output. The default is ERROR.', max_length=20, verbose_name='SFTP Log Level')),
                ('ssh_sftp_log_facility', models.CharField(blank=True, choices=choices.SFTP_LOG_FACILITY, help_text='Specifies the facility code that is used when logging messages from sftp-server.', max_length=20, verbose_name='SFTP Log Facility')),
                ('ssh_options', models.TextField(blank=True, help_text='Extra options to /usr/local/etc/ssh/sshd_config (usually empty). Note, incorrect entered options prevent SSH service to be started.', max_length=120, verbose_name='Extra options')),
                ('ssh_host_dsa_key', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_dsa_key_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_dsa_key_cert_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True, verbose_name='ssh_host_dsa_key-cert.pub')),
                ('ssh_host_ecdsa_key', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_ecdsa_key_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_ecdsa_key_cert_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True, verbose_name='ssh_host_ecdsa_key-cert.pub')),
                ('ssh_host_ed25519_key_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_ed25519_key', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_ed25519_key_cert_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True, verbose_name='ssh_host_ed25519_key-cert.pub')),
                ('ssh_host_key', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_key_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_rsa_key', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_rsa_key_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True)),
                ('ssh_host_rsa_key_cert_pub', models.TextField(blank=True, editable=False, max_length=1024, null=True, verbose_name='ssh_host_rsa_key-cert.pub')),
            ],
            options={
                'verbose_name': 'SSH',
                'verbose_name_plural': 'SSH',
            },
        ),
        migrations.CreateModel(
            name='TFTP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tftp_directory', freenasUI.freeadmin.models.fields.PathField(help_text='The directory containing the files you want to publish. The remote host does not need to pass along the directory as part of the transfer.', max_length=255, verbose_name='Directory')),
                ('tftp_newfiles', models.BooleanField(default=False, verbose_name='Allow New Files')),
                ('tftp_port', models.PositiveIntegerField(default=69, help_text='The port to listen to. The default is to listen to the tftp port specified in /etc/services.', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Port')),
                ('tftp_username', freenasUI.freeadmin.models.fields.UserField(default='nobody', help_text='Specifies the username which the service will run as.', max_length=120, verbose_name='Username')),
                ('tftp_umask', models.CharField(default='022', help_text='Set the umask for newly created files to the specified value. The default is 022 (everyone can read, nobody can write).', max_length=120, verbose_name='umask')),
                ('tftp_options', models.CharField(blank=True, help_text='Extra command line options (usually empty).', max_length=120, verbose_name='Extra options')),
            ],
            options={
                'verbose_name': 'TFTP',
                'verbose_name_plural': 'TFTP',
            },
        ),
        migrations.CreateModel(
            name='UPS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ups_mode', models.CharField(choices=[('master', 'Master'), ('slave', 'Slave')], default='master', max_length=6, verbose_name='UPS Mode')),
                ('ups_identifier', models.CharField(default='ups', help_text='This name is used to uniquely identify your UPS on this system.', max_length=120, verbose_name='Identifier')),
                ('ups_remotehost', models.CharField(blank=True, max_length=50, verbose_name='Remote Host')),
                ('ups_remoteport', models.IntegerField(blank=True, default=3493, verbose_name='Remote Port')),
                ('ups_driver', models.CharField(blank=True, choices=choices.UPSDRIVER_CHOICES(), help_text='The driver used to communicate with your UPS.', max_length=120, verbose_name='Driver')),
                ('ups_port', models.CharField(blank=True, help_text='The serial or USB port where your UPS is connected.', max_length=120, verbose_name='Port')),
                ('ups_options', models.TextField(blank=True, help_text='Additional parameters to the hardware-specific part of the driver.', verbose_name='Auxiliary parameters (ups.conf)')),
                ('ups_optionsupsd', models.TextField(blank=True, help_text='Additional parameters to the hardware-specific part of the driver.', verbose_name='Auxiliary parameters (upsd.conf)')),
                ('ups_description', models.CharField(blank=True, max_length=120, verbose_name='Description')),
                ('ups_shutdown', models.CharField(choices=choices.UPS_CHOICES, default='batt', max_length=120, verbose_name='Shutdown mode')),
                ('ups_shutdowntimer', models.IntegerField(default=30, help_text='The time in seconds until shutdown is initiated. If the UPS happens to come back before the time is up the shutdown is canceled.', verbose_name='Shutdown timer')),
                ('ups_shutdowncmd', models.CharField(default='/sbin/shutdown -p now', help_text='The command used to shutdown the server. You can use a custom command here to perform other tasks before shutdown.default: /sbin/shutdown -p now', max_length=255, verbose_name='Shutdown Command')),
                ('ups_monuser', models.CharField(default='upsmon', max_length=50, verbose_name='Monitor User')),
                ('ups_monpwd', models.CharField(default='fixmepass', max_length=30, verbose_name='Monitor Password')),
                ('ups_extrausers', models.TextField(blank=True, verbose_name='Extra users (upsd.users)')),
                ('ups_rmonitor', models.BooleanField(default=False, verbose_name='Remote Monitor')),
                ('ups_emailnotify', models.BooleanField(default=False, verbose_name='Send Email Status Updates')),
                ('ups_toemail', models.CharField(blank=True, help_text='Destination email address. Separate email addresses by semi-colon.', max_length=120, verbose_name='To email')),
                ('ups_subject', models.CharField(default='UPS report generated by %h', help_text='The subject of the email. You can use the following parameters for substitution:<br /><ul><li>%d - Date</li><li>%h - Hostname</li></ul>', max_length=120, verbose_name='Email Subject')),
                ('ups_powerdown', models.BooleanField(default=True, help_text='Signal the UPS to power off after FreeNAS shuts down.', verbose_name='Power Off UPS')),
            ],
            options={
                'verbose_name': 'UPS',
                'verbose_name_plural': 'UPS',
            },
        ),
        migrations.CreateModel(
            name='WebDAV',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('webdav_protocol', models.CharField(choices=choices.PROTOCOL_CHOICES, default='http', max_length=120, verbose_name='Protocol')),
                ('webdav_tcpport', models.PositiveIntegerField(default=8080, help_text='The port on which WebDAV will run.<br>Do not use a port that is already in use by another service (e.g. 22 for SSH).', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='HTTP Port')),
                ('webdav_tcpportssl', models.PositiveIntegerField(default=8081, help_text='The port on which Secure WebDAV will run.<br>Do not use a port that is already in use by another service (e.g. 22 for SSH).', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='HTTPS Port')),
                ('webdav_password', models.CharField(default='davtest', help_text='The Default Password is: davtest', max_length=120, verbose_name='Webdav Password')),
                ('webdav_htauth', models.CharField(choices=choices.HTAUTH_CHOICES, default='digest', help_text='Type of HTTP Authentication for WebDAV<br>Basic Auth: Password is sent over the network as plaintext (Avoid if HTTPS is disabled) <br>Digest Auth: The hash of the password is sent over the network (more secure).', max_length=120, verbose_name='HTTP Authentication')),
                ('webdav_certssl', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.Certificate', verbose_name='Webdav SSL Certificate')),
            ],
            options={
                'verbose_name': 'WebDAV',
                'verbose_name_plural': 'WebDAV',
            },
        ),
        migrations.AddField(
            model_name='iscsitargetgroups',
            name='iscsi_target_portalgroup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='services.iSCSITargetPortal', verbose_name='Portal Group ID'),
        ),
        migrations.AddField(
            model_name='fibrechanneltotarget',
            name='fc_target',
            field=models.ForeignKey(help_text='Target this extent belongs to', null=True, on_delete=django.db.models.deletion.CASCADE, to='services.iSCSITarget', verbose_name='Target'),
        ),
        migrations.AlterUniqueTogether(
            name='iscsitargettoextent',
            unique_together=set([('iscsi_target', 'iscsi_extent')]),
        ),
        migrations.AlterUniqueTogether(
            name='iscsitargetportalip',
            unique_together=set([('iscsi_target_portalip_ip', 'iscsi_target_portalip_port')]),
        ),
        migrations.AlterUniqueTogether(
            name='iscsitargetgroups',
            unique_together=set([('iscsi_target', 'iscsi_target_portalgroup')]),
        ),
        migrations.RunPython(create_services),
    ]
