# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-07 10:06
from __future__ import unicode_literals

from django.db import migrations, models
import freenasUI.freeadmin.models.fields


def s3_browser_on(apps, schemaeditor):
    """
    Browser option never worked so change all existing values to True so people
    wont see a break of functionality on upgraded.
    """
    s3 = apps.get_model('services', 's3')
    s3.objects.all().update(s3_browser=True)


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0026_delete_vm_kmem_size_tunable'),
    ]

    operations = [
        migrations.AlterField(
            model_name='s3',
            name='s3_browser',
            field=models.BooleanField(default=True, help_text='Enable the web user interface for the S3 service', verbose_name='Enable Browser'),
        ),
        migrations.RunPython(
            s3_browser_on,
        ),
    ]
