# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-11-23 15:19
from __future__ import unicode_literals

from django.db import migrations


def migrate_afp_timemachine_quota(apps, schema_editor):
    AFP_Share = apps.get_model('sharing', 'afp_share')
    for row in AFP_Share.objects.all():
        row.afp_timemachine_quota = int(row.afp_timemachine_quota / 1024 / 1024)
        row.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sharing', '0005_add_cifs_abe'),
    ]

    operations = [
        migrations.RunPython(
            migrate_afp_timemachine_quota,
        ),
    ]
