# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-10-16 09:59
from __future__ import unicode_literals

import os

from django.db import migrations, models
import freenasUI.freeadmin.models.fields


def dataset_normpath(apps, schema_editor):
    Task = apps.get_model('storage', 'Task')
    for task in Task.objects.all():
        task.task_dataset = os.path.normpath(task.task_dataset.strip().strip("/").strip())
        task.save()


def set_naming_schema(apps, schema_editor):
    Task = apps.get_model('storage', 'Task')
    for task in Task.objects.all():
        task.task_naming_schema = f"auto-%Y%m%d.%H%M%S-{task.task_ret_count}{task.task_ret_unit[0]}"
        task.save()


def lifetime_unit_upper(apps, schema_editor):
    Task = apps.get_model('storage', 'Task')
    for task in Task.objects.all():
        task.task_lifetime_unit = task.task_lifetime_unit.upper()
        task.save()


def migrate_schedule(apps, schema_editor):
    Task = apps.get_model('storage', 'Task')
    for task in Task.objects.all():
        task.task_minute = "0"
        task.task_hour = "*"
        task.task_daymonth = "*"
        task.task_month = "*"
        task.task_dayweek = "*"

        if task.task_repeat_unit == "weekly":
            task.task_dayweek = task.task_byweekday
        else:
            task.task_dayweek = "*"

        if task.task_interval == 40320:
            task.task_minute = str(task.task_begin.minute)
            task.task_hour = str(task.task_begin.hour)
            task.task_daymonth = "1"
        elif task.task_interval == 20160:
            task.task_minute = str(task.task_begin.minute)
            task.task_hour = str(task.task_begin.hour)
            task.task_daymonth = "1,15"
        elif task.task_interval == 10080:
            task.task_minute = str(task.task_begin.minute)
            task.task_hour = str(task.task_begin.hour)
            task.task_daymonth = "*"
            task.task_dayweek = "1"
        elif task.task_interval == 1440:
            task.task_minute = str(task.task_begin.minute)
            task.task_hour = str(task.task_begin.hour)
        elif task.task_interval >= 60:
            task.task_hour = "*/" + str(int(task.task_interval / 60))
        else:
            task.task_minute = "*/" + str(task.task_interval)

        task.save()


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0011_disk_temperatures'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='task',
            options={'verbose_name': 'Periodic Snapshot Task', 'verbose_name_plural': 'Periodic Snapshot Tasks', 'ordering': ['task_dataset']},
        ),

        migrations.RenameField(
            model_name='task',
            old_name='task_filesystem',
            new_name='task_dataset',
        ),
        migrations.RunPython(
            dataset_normpath,
        ),

        migrations.AddField(
            model_name='task',
            name='task_exclude',
            field=freenasUI.freeadmin.models.fields.ListField(default=[], verbose_name='Exclude child datasets'),
            preserve_default=False,
        ),

        migrations.AddField(
            model_name='task',
            name='task_naming_schema',
            field=models.CharField(default='auto-%Y-%m-%d_%H-%M', max_length=150, verbose_name='Naming schema'),
            preserve_default=False,
        ),
        migrations.RunPython(
            set_naming_schema,
        ),

        migrations.AddField(
            model_name='task',
            name='task_minute',
            field=models.CharField(default='00',
                                   help_text='Values allowed:<br>Slider: 0-30 (as it is every Nth minute).<br>Specific Minute: 0-59.',
                                   max_length=100, verbose_name='Minute'),
        ),
        migrations.AddField(
            model_name='task',
            name='task_hour',
            field=models.CharField(default='*',
                                   help_text='Values allowed:<br>Slider: 0-12 (as it is every Nth hour).<br>Specific Hour: 0-23.',
                                   max_length=100, verbose_name='Hour'),
        ),
        migrations.AddField(
            model_name='task',
            name='task_daymonth',
            field=models.CharField(default='*',
                                   help_text='Values allowed:<br>Slider: 0-15 (as its is every Nth day).<br>Specific Day: 1-31.',
                                   max_length=100, verbose_name='Day of month'),
        ),
        migrations.AddField(
            model_name='task',
            name='task_month',
            field=models.CharField(default='*', max_length=100, verbose_name='Month'),
        ),
        migrations.AddField(
            model_name='task',
            name='task_dayweek',
            field=models.CharField(default='*', max_length=100, verbose_name='Day of week'),
        ),
        migrations.RunPython(
            migrate_schedule,
        ),
        migrations.RemoveField(
            model_name='task',
            name='task_interval',
        ),
        migrations.RemoveField(
            model_name='task',
            name='task_repeat_unit',
        ),
        migrations.RemoveField(
            model_name='task',
            name='task_byweekday',
        ),
        migrations.RenameField(
            model_name='task',
            old_name='task_ret_unit',
            new_name='task_lifetime_unit',
        ),
        migrations.AlterField(
            model_name='task',
            name='task_lifetime_unit',
            field=models.CharField(choices=[('HOUR', 'Hour(s)'), ('DAY', 'Day(s)'), ('WEEK', 'Week(s)'), ('MONTH', 'Month(s)'), ('YEAR', 'Year(s)')], default='WEEK', max_length=120, verbose_name='Snapshot lifetime unit'),
        ),
        migrations.RunPython(
            lifetime_unit_upper,
        ),
        migrations.RenameField(
            model_name='task',
            old_name='task_ret_count',
            new_name='task_lifetime_value',
        ),
    ]
