# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-11-24 18:54
from __future__ import unicode_literals

import datetime
from django.db import migrations, models


def null_restrict_schedule(apps, schema_editor):
    Replication = apps.get_model('storage', 'Replication')
    for replication in Replication.objects.all():
        replication.repl_restrict_schedule_minute = None
        replication.repl_restrict_schedule_hour = None
        replication.repl_restrict_schedule_daymonth = None
        replication.repl_restrict_schedule_month = None
        replication.repl_restrict_schedule_dayweek = None
        replication.save()


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0014_replication_schedule'),
    ]

    operations = [
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_minute',
            field=models.CharField(default='00', help_text='Values allowed:<br>Slider: 0-30 (as it is every Nth minute).<br>Specific Minute: 0-59.', max_length=100, null=True, verbose_name='Minute'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_hour',
            field=models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-12 (as it is every Nth hour).<br>Specific Hour: 0-23.', max_length=100, null=True, verbose_name='Hour'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_daymonth',
            field=models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-15 (as its is every Nth day).<br>Specific Day: 1-31.', max_length=100, null=True, verbose_name='Day of month'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_month',
            field=models.CharField(default='*', max_length=100, null=True, verbose_name='Month'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_dayweek',
            field=models.CharField(default='*', max_length=100, null=True, verbose_name='Day of week'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_begin',
            field=models.TimeField(default=datetime.time(0, 0), help_text='Do not start replication before', null=True, verbose_name='Begin'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_restrict_schedule_end',
            field=models.TimeField(default=datetime.time(23, 59), help_text='Do not start replication after', null=True, verbose_name='End'),
        ),

        migrations.RunPython(null_restrict_schedule),
    ]
