# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-07-01 07:21
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields


def snmp_trap_alert_service(apps, schema_editor):
    AlertService = apps.get_model('system', 'AlertService')
    for alert_service in AlertService.objects.all():
        if alert_service.type == 'SNMPTrap':
            alert_service.attributes = {
                'host': 'localhost',
                'port': 162,
                'v3': False,
                'community': 'public',
            }
            alert_service.save()


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0043_usage_collection'),
    ]

    operations = [
        migrations.RunPython(snmp_trap_alert_service),
    ]
