# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-07-03 12:18
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields
import re


def migrate_fromname(apps, schema_editor):
    Email = apps.get_model('system', 'Email')
    for email in Email.objects.all():
        m = re.match('(.+) <(.+)>', email.em_fromemail)
        if m:
            email.em_fromemail = m.group(2)
            email.em_fromname = m.group(1).strip().strip('"')
            email.save()


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0044_snmp_trap_alert_service'),
    ]

    operations = [
        migrations.AddField(
            model_name='email',
            name='em_fromname',
            field=models.CharField(default='', help_text='A name which will be displayed in the "From" header of e-mail message', max_length=120, verbose_name='From name'),
        ),
        migrations.RunPython(
            migrate_fromname,
        ),
    ]
