# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:43


import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('system', '0001_initial'),
        ('storage', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CloudSync',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=150, verbose_name='Description')),
                ('direction', models.CharField(choices=[('PUSH', 'Push'), ('PULL', 'Pull')], default='PUSH', help_text='Push - From local to remote. Pull - From remote to local.', max_length=10, verbose_name='Direction')),
                ('path', freenasUI.freeadmin.models.fields.PathField(max_length=255, verbose_name='Path')),
                ('attributes', freenasUI.freeadmin.models.fields.DictField(editable=False)),
                ('minute', models.CharField(default='00', help_text='Values allowed:<br>Slider: 0-30 (as it is every Nth minute).<br>Specific Minute: 0-59.', max_length=100, verbose_name='Minute')),
                ('hour', models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-12 (as it is every Nth hour).<br>Specific Hour: 0-23.', max_length=100, verbose_name='Hour')),
                ('daymonth', models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-15 (as its is every Nth day).<br>Specific Day: 1-31.', max_length=100, verbose_name='Day of month')),
                ('month', models.CharField(default='*', max_length=100, verbose_name='Month')),
                ('dayweek', models.CharField(default='*', max_length=100, verbose_name='Day of week')),
                ('enabled', models.BooleanField(default=True, help_text='Disabling will not stop any syncs which are in progress.', verbose_name='Enabled')),
                ('credential', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='system.CloudCredentials', verbose_name='Credential')),
            ],
            options={
                'ordering': ['description'],
                'verbose_name': 'Cloud Sync',
                'verbose_name_plural': 'Cloud Syncs',
            },
        ),
        migrations.CreateModel(
            name='CronJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cron_user', freenasUI.freeadmin.models.fields.UserField(help_text='The user to run the command', max_length=60, verbose_name='User')),
                ('cron_command', models.TextField(verbose_name='Command')),
                ('cron_description', models.CharField(blank=True, max_length=200, verbose_name='Short description')),
                ('cron_minute', models.CharField(default='00', help_text='Values 0-59 allowed.', max_length=100, verbose_name='Minute')),
                ('cron_hour', models.CharField(default='*', help_text='Values 0-23 allowed.', max_length=100, verbose_name='Hour')),
                ('cron_daymonth', models.CharField(default='*', help_text='Values 1-31 allowed.', max_length=100, verbose_name='Day of month')),
                ('cron_month', models.CharField(default='*', max_length=100, verbose_name='Month')),
                ('cron_dayweek', models.CharField(default='*', max_length=100, verbose_name='Day of week')),
                ('cron_stdout', models.BooleanField(default=True, help_text='Redirect the standard output to /dev/null. In other words, disable output.', verbose_name='Redirect Stdout')),
                ('cron_stderr', models.BooleanField(default=False, help_text='Redirect the standard error output to /dev/null. In other words, disable error output.', verbose_name='Redirect Stderr')),
                ('cron_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'ordering': ['cron_description', 'cron_user'],
                'verbose_name': 'Cron Job',
                'verbose_name_plural': 'Cron Jobs',
            },
        ),
        migrations.CreateModel(
            name='InitShutdown',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ini_type', models.CharField(choices=[('command', 'Command'), ('script', 'Script')], default='command', max_length=15, verbose_name='Type')),
                ('ini_command', models.CharField(blank=True, max_length=300, verbose_name='Command')),
                ('ini_script', freenasUI.freeadmin.models.fields.PathField(blank=True, max_length=255, null=True, verbose_name='Script')),
                ('ini_when', models.CharField(choices=[('preinit', 'Pre Init'), ('postinit', 'Post Init'), ('shutdown', 'Shutdown')], max_length=15, verbose_name='When')),
            ],
            options={
                'verbose_name': 'Init/Shutdown Script',
                'verbose_name_plural': 'Init/Shutdown Scripts',
            },
        ),
        migrations.CreateModel(
            name='Rsync',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rsync_path', freenasUI.freeadmin.models.fields.PathField(max_length=255, verbose_name='Path')),
                ('rsync_remotehost', models.CharField(help_text='IP Address or hostname. Specify user@hostname or user@ip-address if your remote machine user and above rsync task user are different.', max_length=120, verbose_name='Remote Host')),
                ('rsync_remoteport', models.SmallIntegerField(default=22, help_text='SSH Port', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Remote SSH Port')),
                ('rsync_mode', models.CharField(choices=[('module', 'Rsync module'), ('ssh', 'Rsync over SSH')], default='module', max_length=20)),
                ('rsync_remotemodule', models.CharField(blank=True, help_text='Name of the module defined in the remote rsync daemon', max_length=120, verbose_name='Remote Module Name')),
                ('rsync_remotepath', models.CharField(blank=True, help_text='Path on remote host to rsync to, e.g. /mnt/tank', max_length=255, verbose_name='Remote Path')),
                ('rsync_direction', models.CharField(choices=[('push', 'Push'), ('pull', 'Pull')], default='push', help_text='Push - From local to remote machine. Pull - From remote to local machine.', max_length=10, verbose_name='Direction')),
                ('rsync_desc', models.CharField(blank=True, max_length=120, verbose_name='Short description')),
                ('rsync_minute', models.CharField(default='00', help_text='Values allowed:<br>Slider: 0-30 (as it is every Nth minute).<br>Specific Minute: 0-59.', max_length=100, verbose_name='Minute')),
                ('rsync_hour', models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-12 (as it is every Nth hour).<br>Specific Hour: 0-23.', max_length=100, verbose_name='Hour')),
                ('rsync_daymonth', models.CharField(default='*', help_text='Values allowed:<br>Slider: 0-15 (as its is every Nth day).<br>Specific Day: 1-31.', max_length=100, verbose_name='Day of month')),
                ('rsync_month', models.CharField(default='*', max_length=100, verbose_name='Month')),
                ('rsync_dayweek', models.CharField(default='*', max_length=100, verbose_name='Day of week')),
                ('rsync_user', freenasUI.freeadmin.models.fields.UserField(help_text='The user to run the command', max_length=60, verbose_name='User')),
                ('rsync_recursive', models.BooleanField(default=True, help_text='Recurse into directories', verbose_name='Recursive')),
                ('rsync_times', models.BooleanField(default=True, help_text='Preserve modification times', verbose_name='Times')),
                ('rsync_compress', models.BooleanField(default=True, help_text='Compress data during the transfer', verbose_name='Compress')),
                ('rsync_archive', models.BooleanField(default=False, help_text='Archive mode', verbose_name='Archive')),
                ('rsync_delete', models.BooleanField(default=False, help_text="Delete files on the receiving side that don't exist on sender", verbose_name='Delete')),
                ('rsync_quiet', models.BooleanField(default=False, help_text='Suppress non-error messages', verbose_name='Quiet')),
                ('rsync_preserveperm', models.BooleanField(default=False, help_text='This option causes the receiving rsync to set the destination permissions to be the same as the source permissions', verbose_name='Preserve permissions')),
                ('rsync_preserveattr', models.BooleanField(default=False, help_text='This option causes rsync to update the remote extended attributes to be the same as the local ones', verbose_name='Preserve extended attributes')),
                ('rsync_delayupdates', models.BooleanField(default=True, help_text='Put all updated files into place at the end', verbose_name='Delay Updates')),
                ('rsync_extra', models.TextField(blank=True, help_text='Extra options to rsync command line (usually empty)', verbose_name='Extra options')),
                ('rsync_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'ordering': ['rsync_path', 'rsync_desc'],
                'verbose_name': 'Rsync Task',
                'verbose_name_plural': 'Rsync Tasks',
            },
        ),
        migrations.CreateModel(
            name='SMARTTest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('smarttest_type', models.CharField(choices=[('L', 'Long Self-Test'), ('S', 'Short Self-Test'), ('C', 'Conveyance Self-Test (ATA  only)'), ('O', 'Offline Immediate Test (ATA only)')], max_length=2, verbose_name='Type')),
                ('smarttest_desc', models.CharField(blank=True, max_length=120, verbose_name='Short description')),
                ('smarttest_hour', models.CharField(default='*', help_text='Values 0-23 allowed.', max_length=100, verbose_name='Hour')),
                ('smarttest_daymonth', models.CharField(default='*', help_text='Values 1-31 allowed.', max_length=100, verbose_name='Day of month')),
                ('smarttest_month', models.CharField(default='*', max_length=100, verbose_name='Month')),
                ('smarttest_dayweek', models.CharField(default='*', max_length=100, verbose_name='Day of week')),
                ('smarttest_disks', models.ManyToManyField(to='storage.Disk', verbose_name='Disks')),
            ],
            options={
                'ordering': ['smarttest_type'],
                'verbose_name': 'S.M.A.R.T. Test',
                'verbose_name_plural': 'S.M.A.R.T. Tests',
            },
        ),
    ]
